<?php

App::uses('AppModel', 'Model');

class Bundle extends AppModel
{
    public $hasMany = array('Link');
    
    public $belongsTo = array( 'User' );
    
    public $validate = array(
        'name' => array(
            'notBlank' => array(
                'rule' => 'notBlank',
                'message' => 'A bundle name is required.'
            )
        ),
    );
    
    public function afterDelete()
    {
        
        $this->Link->updateAll(
            array(
                'Link.bundle_id' => 0
            ),
            array('Link.bundle_id' => $this->id, 'Link.user_id' => $this->userId)
        );
        
        
    }
    
    public function isOwnedBy($editId, $userId)
    {
        return $this->field('user_id', array('id' => $editId)) === $userId;
    }
    
    public function getNewBundleId()
    {
        App::uses('User', 'Model');
        $user = new User();
        $lastBundleId = $user->field('User.last_bundle_id', array('User.id' => $_SESSION['Auth']['User']['id']));
        if (!$lastBundleId) {
            $lastBundleId = 0;
        }
        $lastBundleId = $lastBundleId + 1;
        return $lastBundleId;
    }
}
